using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgCancelOrder
	/// </summary>
	public class DlgCancelOrder : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private DataTable _dtCannedComments;
		private Guid _cannedCommentGuid;
		private string	_cannedCommentText;

		private System.Windows.Forms.GroupBox grpIcon;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpComment;
		private System.Windows.Forms.PictureBox picWarning;
		private System.Windows.Forms.Label lblCancelMessage;
		private System.Windows.Forms.Label lblComment;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.TextBox txtComment;
		private System.Windows.Forms.Label lblDetails;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgCancelOrder()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
		}

		/// <summary>
		/// Get/Set CannedCommentGuid
		/// </summary>
		public Guid CannedCommentGuid
		{
			get 
			{
				return _cannedCommentGuid;
			}
			set 
			{
				_cannedCommentGuid = value;
			}
		}

		/// <summary>
		/// Get/Set CannedCommentText
		/// </summary>
		public string CannedCommentText
		{
			get 
			{
				return _cannedCommentText + ", " + this.txtComment.Text;
			}
			set 
			{
				_cannedCommentText = value;
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";

			this._dtCannedComments = BOL.CannedComment.GetCannedComments(LogonUser.LogonUserDivisionCode, "OC");

			foreach(DataRow dr in _dtCannedComments.Rows)
			{
				this.cmbComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText]);
			}

			this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.Common.CommentRequired().ResString);
			this.btnOK.EnabledButton = false;
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgCancelOrder));
			this.grpIcon = new System.Windows.Forms.GroupBox();
			this.picWarning = new System.Windows.Forms.PictureBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpComment = new System.Windows.Forms.GroupBox();
			this.txtComment = new System.Windows.Forms.TextBox();
			this.lblDetails = new System.Windows.Forms.Label();
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblComment = new System.Windows.Forms.Label();
			this.lblCancelMessage = new System.Windows.Forms.Label();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpIcon.SuspendLayout();
			this.grpComment.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(384, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Reject Order";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 217);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// grpIcon
			// 
			this.grpIcon.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpIcon.Controls.Add(this.picWarning);
			this.grpIcon.Location = new System.Drawing.Point(4, 36);
			this.grpIcon.Name = "grpIcon";
			this.grpIcon.Size = new System.Drawing.Size(52, 168);
			this.grpIcon.TabIndex = 4;
			this.grpIcon.TabStop = false;
			// 
			// picWarning
			// 
			this.picWarning.Image = ((System.Drawing.Image)(resources.GetObject("picWarning.Image")));
			this.picWarning.Location = new System.Drawing.Point(4, 12);
			this.picWarning.Name = "picWarning";
			this.picWarning.Size = new System.Drawing.Size(45, 45);
			this.picWarning.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picWarning.TabIndex = 0;
			this.picWarning.TabStop = false;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(304, 208);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpComment
			// 
			this.grpComment.AccessibleDescription = "Enter a comment to justify rejecting a pending order.";
			this.grpComment.AccessibleName = "Enter a comment to justify rejecting a pending order.";
			this.grpComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpComment.Controls.Add(this.txtComment);
			this.grpComment.Controls.Add(this.lblDetails);
			this.grpComment.Controls.Add(this.cmbComment);
			this.grpComment.Controls.Add(this.lblComment);
			this.grpComment.Controls.Add(this.lblCancelMessage);
			this.grpComment.Location = new System.Drawing.Point(60, 36);
			this.grpComment.Name = "grpComment";
			this.grpComment.Size = new System.Drawing.Size(320, 168);
			this.grpComment.TabIndex = 0;
			this.grpComment.TabStop = false;
			// 
			// txtComment
			// 
			this.txtComment.AcceptsReturn = true;
			this.txtComment.AccessibleDescription = "Details";
			this.txtComment.AccessibleName = "Details";
			this.txtComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComment.Location = new System.Drawing.Point(72, 80);
			this.txtComment.MaxLength = 255;
			this.txtComment.Multiline = true;
			this.txtComment.Name = "txtComment";
			this.txtComment.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtComment.Size = new System.Drawing.Size(236, 80);
			this.txtComment.TabIndex = 4;
			this.txtComment.Text = "";
			this.txtComment.TextChanged += new System.EventHandler(this.txtComment_TextChanged);
			// 
			// lblDetails
			// 
			this.lblDetails.Location = new System.Drawing.Point(8, 80);
			this.lblDetails.Name = "lblDetails";
			this.lblDetails.Size = new System.Drawing.Size(60, 20);
			this.lblDetails.TabIndex = 3;
			this.lblDetails.Text = "Details";
			this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbComment
			// 
			this.cmbComment.AccessibleDescription = "Comment";
			this.cmbComment.AccessibleName = "Comment";
			this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComment.Interval = 500;
			this.cmbComment.Location = new System.Drawing.Point(72, 52);
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(236, 22);
			this.cmbComment.TabIndex = 2;
			this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
			// 
			// lblComment
			// 
			this.lblComment.Location = new System.Drawing.Point(8, 56);
			this.lblComment.Name = "lblComment";
			this.lblComment.Size = new System.Drawing.Size(64, 23);
			this.lblComment.TabIndex = 1;
			this.lblComment.Text = "Comment*";
			// 
			// lblCancelMessage
			// 
			this.lblCancelMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblCancelMessage.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblCancelMessage.Location = new System.Drawing.Point(8, 16);
			this.lblCancelMessage.Name = "lblCancelMessage";
			this.lblCancelMessage.Size = new System.Drawing.Size(296, 24);
			this.lblCancelMessage.TabIndex = 0;
			this.lblCancelMessage.Tag = "";
			this.lblCancelMessage.Text = "Enter a comment to justify rejecting a pending order.";
			this.lblCancelMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(224, 208);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// DlgCancelOrder
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(384, 233);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpComment);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpIcon);
			this.hlphelpChm.SetHelpKeyword(this, "Cancel_a_Pending_Order.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "DlgCancelOrder";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Reject Order";
			this.Controls.SetChildIndex(this.grpIcon, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpComment, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpIcon.ResumeLayout(false);
			this.grpComment.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.cmbComment.SelectedIndex>-1)
			{
				this.btnOK.EnabledButton = true;
				//
                // CR2814: Add an escape character so queries with single quotes don't crash.
                string filter = Common.VbecsTables.CannedComment.CannedCommentText + " = '" + this.cmbComment.Text.Replace("'", "''") + "'";
				DataRow [] dr = this._dtCannedComments.Select(filter);
				if (dr != null && dr.Length == 1)
				{
					//this.CannedCommentID = (int) dr[0][Common.VbecsTables.CannedComment.CannedCommentID];
					this.CannedCommentGuid = (Guid) dr[0][Common.VbecsTables.CannedComment.CannedCommentGuid];
					this.CannedCommentText = this.cmbComment.Text;
				}
				if (this._cannedCommentText.Trim() == "Other" && this.txtComment.Text.Trim().Length == 0)
				{
					this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.Common.CommentRequiredWithOther().ResString);
					this.btnOK.EnabledButton = false;
				}
				else if (this._cannedCommentText.Trim().Length == 0)
				{	
					this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.Common.CommentRequired().ResString);
					this.btnOK.EnabledButton = false;
				}
			}
			else
			{
				this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.Common.CommentRequired().ResString);
				this.btnOK.EnabledButton = false;
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.Close();
			this.DialogResult = DialogResult.OK;
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
			this.DialogResult = DialogResult.Cancel;
		}

		private void txtComment_TextChanged(object sender, System.EventArgs e)
		{
			if (txtComment.Text.Trim().Length == 0)
			{
				this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.Common.CommentRequiredWithOther().ResString);
				this.btnOK.EnabledButton = false;
			}
			else
			{
				this.btnOK.EnabledButton = true;
				this.ttToolTip.SetToolTip(btnOK, string.Empty);
			}
		}
	}
}

